const multer = require('multer');
const path = require('path');
const fs = require('fs');

// Ensure folders exist
const ensureFolderExists = folder => {
    if (!fs.existsSync(folder)) {
        fs.mkdirSync(folder, { recursive: true }); // create all parent folders if missing
    }
};

const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        const folder = file.fieldname === 'video' ? 'uploads/videos' : 'uploads/thumbs';
        ensureFolderExists(folder); // create folder if missing
        cb(null, folder);
    },
    filename: (req, file, cb) => {
        cb(null, Date.now() + path.extname(file.originalname));
    }
});

const upload = multer({ 
    storage,
    limits: { fileSize: 2 * 1024 * 1024 * 1024 } // 2GB Limit
});

module.exports = upload;
