const jwt = require('jsonwebtoken');

const verifyToken = (req, res, next) => {
    const token = req.headers['authorization']?.split(' ')[1];
    console.log(token);
    

    if (!token) return res.status(403).json({ message: "Access Denied: No Token Provided" });

    try {
        const verified = jwt.verify(token, process.env.JWT_SECRET);
        req.admin = verified;
        next(); 
    } catch (err) {
        res.status(401).json({ message: "Invalid or Expired Token" });
    }
};

module.exports = verifyToken;