const express = require('express');
const router = express.Router();
const videoController = require('../controllers/videoController'); 
const verifyToken = require('../middleware/verifyToken');
const upload = require('../middleware/upload');

router.get('/', videoController.getAllVideos);
router.get('/:id', videoController.getVideoById);

router.post('/upload', 
    verifyToken, 
    upload.fields([
        { name: 'video', maxCount: 1 }, 
        { name: 'thumbnail', maxCount: 1 }
    ]), 
    videoController.uploadVideo
);

router.delete('/:id', verifyToken, videoController.deleteVideo); 

module.exports = router;